# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob




def update_package():
    # Declaring local variables
    package_updated = False
    
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()

  
    url_base = "https://www.zotero.org/download/client/dl?channel=release&platform=win-x64"
    data = requests.head(url_base,allow_redirects=True, proxies=proxies).url
    download_url = data
    latest_bin = download_url.split('/')[-1]
    version = download_url.split('/')[-2]


    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
        package_updated = True
    else:
        print("Binary is present: %s" % latest_bin)


    # Deleting outdated binaries
    for f in glob.glob('*.exe'):
        if f != latest_bin:
            remove_file(f)

         
    
    # Mettre à jour le package
    control.set_software_version(version)
    control.save_control_to_wapt()    
        

