# -*- coding: utf-8 -*-
from setuphelpers import *
import json
import requests

def update_package():
    # Initializing variables
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    url = "https://www.zotero.org/download/"

    # Getting latest version from official sources
    print("URL used is: %s" % url)
    for bs_search in bs_find_all(url, "script", "type", "text/javascript", proxies=proxies):
        temp_str = str(bs_search)
        if "linux-x86_64" in temp_str:
            #dict_version = json.loads(temp_str.split(":", 1)[-1].split("\n", 1)[0].split("}")[0] + "}")
            #version = dict_version["linux-x86_64"]
            url_dl = requests.head("https://www.zotero.org/download/client/dl?channel=release&platform=linux-x86_64" , proxies=proxies).headers["Location"]
            latest_bin = url_dl.split("/")[-1]
            version = latest_bin.split("-")[1].split("_")[0]
            break

    print("Latest %s version is: %s" % (app_name, version))
    print("Download url is: %s" % url_dl)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_dl, latest_bin, proxies=proxies)

    # Changing version of the package
    control.version = "%s-%s" % (version, control.version.split("-", 1)[-1])
    control.save_control_to_wapt()

    for f in glob.glob("*.tar.xz"):
        if f != latest_bin:
            remove_file()