# -*- coding: utf-8 -*-
from setuphelpers import *

def update_package():
    print("Download/Update package content from upstream binary sources")

    # Getting proxy informations from WAPT settings
    proxy = get_proxies_from_wapt_console()

    json_version = wgets("https://zoom.us/rest/download?os=mac",proxies=proxy,as_json=True)
    version = json_version["result"]["downloadVO"]["zoom"]["version"]
    
    # Downloading latest binaries
    if isfile("Zoom.pkg"):
        remove_file("Zoom.pkg")

    print("Downloading: " + "Zoom.pkg")
    
    url_dl = f"https://zoom.us/client/{version}/zoomusInstallerFull.pkg"
    version = url_dl.split("/")[-2]

    wget(url_dl, "Zoom.pkg", proxies=proxy)
    
    control.set_software_version(version)
    control.save_control_to_wapt()
