# -*- coding: utf-8 -*-
from setupdevhelpers import *
import requests

def update_package():
    url_dl = "https://zoom.us/client/latest/zoom_amd64.deb"
    print("Download/Update package content from upstream binary sources")

    # Getting proxy informations from WAPT settings
    proxy = get_proxies_from_wapt_console()

    # Downloading latest binaries
    if isfile("Zoom.pkg"):
        remove_file("Zoom.pkg")

    print("Downloading: zoom_amd64.deb")
    url_dl = requests.head(url_dl,proxies=proxy).headers["Location"]

    version = url_dl.split("/")[-2]

    wget(url_dl, "zoom_amd64.deb", proxies=proxy)

    # Change version of the package

    control.version = "%s-%s" % (version, int(control.version.split("-", 1)[1]) + 1)
    control.save_control_to_wapt(".")
    print("Changing version to " + control.version + " in WAPT\\control")
    print("Update package done. You can now build-upload your package")
