# -*- coding: utf-8 -*-
from setuphelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    if control.architecture == "x64":
        download_url = "https://zoom.us/client/latest/ZoomInstallerFull.msi?archType=x64"
    elif control.architecture == "arm64":
        download_url = "https://zoom.us/client/latest/ZoomInstallerFull.msi?archType=winarm64"
    else:
        download_url = "https://zoom.us/client/latest/ZoomInstallerFull.msi?archType=x86"

    # Getting latest version information from download url
    download_url = requests.head(download_url).headers["Location"]
    version = download_url.split("prod/")[1].split("/")[0]
    latest_bin = download_url.split("/")[-1]
    latest_bin_extension = latest_bin.rsplit('.', 1)[-1]

    # Downloading latest binaries
    print(f"Latest {app_name} version is: {version}")
    print(f"Download URL is: {download_url}")
    if not isfile(latest_bin):
        print(f"Downloading: {latest_bin}")
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print(f"Binary is present: {latest_bin}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated
