# -*- coding: utf-8 -*-
from setuphelpers import *


def install():
    run(f'pkgutil --expand-full Zoom.pkg Zoom')
    install_app(
        "Zoom/zoomus.pkg/Payload/zoom.us.app",
        key="/Applications/zoom.us.app",
        min_version=control.get_software_version(),
        get_version=get_version
    )

def uninstall():
    uninstall_app("zoom.us.app")
    uninstall_pkg("us.zoom.pkg.videomeeting")


def get_version(key):
    import re
    version = key['version']
    version = version.replace(' ', '.')
    version = re.sub('[()]', '', version)
    return str(version)