# -*- coding: utf-8 -*-
from setuphelpers import *

"""
UninstallKey                           Software                                                              Version             Uninstallstring
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
{3EA2FA1B-2AAD-4DB6-9340-F37C517ACB6E} Zoom(32bit)                                                           5.10.5263           MsiExec.exe /X{3EA2FA1B-2AAD-4DB6-9340-F37C517ACB6E}
{10F9C1AD-E615-47A6-B3E6-A66308D01F65} Zoom(64bit)                                                           5.10.5035           MsiExec.exe /X{10F9C1AD-E615-47A6-B3E6-A66308D01F65}

{
    "key": "{829BFEC0-7900-490D-B30D-61737D79AFC4}",
    "name": "Zoom (32-bit)",
    "version": "5.17.31859",
    "install_date": "2024-02-09 00:00:00",
    "install_location": "",
    "uninstall_string": "MsiExec.exe /X{829BFEC0-7900-490D-B30D-61737D79AFC4}",
    "publisher": "Zoom",
    "system_component": 0,
    "win64": false,
}
{
    "key": "{499EA83F-642D-40CB-A55E-5D385DEDD376}",
    "name": "Zoom (64-bit)",
    "version": "5.17.31859",
    "install_date": "2024-02-09 00:00:00",
    "install_location": "",
    "uninstall_string": "MsiExec.exe /X{499EA83F-642D-40CB-A55E-5D385DEDD376}",
    "publisher": "Zoom",
    "system_component": 0,
    "win64": true,
} 


Installation procedure: https://support.zoom.us/hc/articles/201362163-Mass-Installation-and-Configuration-for-Windows

"""
bin_name = "ZoomInstallerFull.msi"
silentflags = (
    'ZoomAutoUpdate=false ZNoDesktopShortCut=true ZoomAutoStart=false ZSILENTSTART=false ZConfig="DisableAdvancedSharingService=1;AddFWException=1"'
)


def get_app_path_version(key):
    if control.architecture == "x64":
        app_path = makepath(programfiles, r"Zoom\bin\Zoom.exe")
    else:
        app_path = makepath(programfiles32, r"Zoom\bin\Zoom.exe")
    return get_file_properties(app_path)["FileVersion"]


def install():
    # Uninstalling the other architecture of the software
    if iswin64():
        for to_uninstall in installed_softwares(name=r"Zoom\s?\((64|32)-bit\)"):
            if not to_uninstall["win64"]:
                print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
                killalltasks(control.impacted_process.split(","))
                run(uninstall_cmd(to_uninstall["key"]))
                wait_uninstallkey_absent(to_uninstall["key"])

    # Installing the software
    print("Installing: %s (%s)" % (get_msi_properties(bin_name)["ProductName"], control.get_software_version()))
    install_msi_if_needed(
        bin_name,
        properties=silentflags,
        min_version=control.get_software_version(),
        get_version=get_app_path_version,
    )
