# -*- coding: utf-8 -*-
from setuphelpers import *

"""
{
    "key":"{E74A40B7-7C5F-422D-A2A5-769243C4BCB2}",
    "name":"Zoom Workplace (64-bit)",
    "version":"6.7.26346",
    "install_date":"2026-02-09 00:00:00",
    "install_location":"",
    "uninstall_string":"MsiExec.exe /X{E74A40B7-7C5F-422D-A2A5-769243C4BCB2}",
    "publisher":"Zoom",
    "system_component":0,
    "win64":true
}
{
    "key":"{53F158D1-567B-4F52-9BFA-DD2D5544AFD1}",
    "name":"Zoom Workplace (ARM64)",
    "version":"6.7.26346",
    "install_date":"2026-02-09 00:00:00",
    "install_location":"",
    "uninstall_string":"MsiExec.exe /X{53F158D1-567B-4F52-9BFA-DD2D5544AFD1}",
    "publisher":"Zoom",
    "system_component":0,
    "win64":true
}

Installation procedure: https://support.zoom.us/hc/articles/201362163-Mass-Installation-and-Configuration-for-Windows

"""
bin_name = "ZoomInstallerFull.msi"
silentflags = (
    'ZoomAutoUpdate=false ZNoDesktopShortCut=true ZoomAutoStart=false ZSILENTSTART=false ZConfig="DisableAdvancedSharingService=1;AddFWException=1"'
)

def install():
    # Uninstalling the other architecture of the software
    if iswinarm():
        for to_uninstall in installed_softwares(name='Zoom Workplace'):
            if 'ARM64' not in to_uninstall['name']:
                print(f"Removing: {to_uninstall['name']} ({to_uninstall['version']})")
                killalltasks(ensure_list(control.impacted_process))
                run(uninstall_cmd(to_uninstall["key"]))
                wait_uninstallkey_absent(to_uninstall["key"])

    install_msi_if_needed(
        bin_name,
        name=r"Zoom Workplace \(ARM64\)",
        properties=silentflags,
        min_version=control.get_software_version()
    )
