# -*- coding: utf-8 -*-
from setuphelpers import *
import requests
import msilib


bin_name = "ZoomInstallerFull.msi"
url_dl = "https://www.zoom.us/client/latest/ZoomInstallerFull.msi"


def get_zoom_product_version(msi_filename):
    # Get version from description msi
    db = msilib.OpenDatabase(msi_filename, msilib.MSIDBOPEN_READONLY)
    db.GetSummaryInformation(1)
    description = db.GetSummaryInformation(1).GetProperty(6)
    return ensure_unicode(description).replace(" (", ".").split(")")[0]


def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    if control.architecture == "x64":
        download_url = "https://zoom.us/client/latest/ZoomInstallerFull.msi?archType=x64"
    else:
        download_url = "https://zoom.us/client/latest/ZoomInstallerFull.msi?archType=x86"

    # Getting latest version information from download url
    download_url = requests.head(download_url, allow_redirects=False).headers["Location"]
    version = download_url.split("prod/")[1].split("/")[0]
    latest_bin = download_url.split("/")[-1]

    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    if Version(get_zoom_product_version(latest_bin)) != Version(version):
        remove_file(latest_bin)
        error("The version returned by the request and the version returned by the msi does not match")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return result
