# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob


def update_package():
    # Declaration of local variables
    package_updated = False
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()
    api_url = "https://api.github.com/repos/Zettlr/Zettlr/releases/latest"

    # Get data from API
    releases_dict = wgets(api_url, proxies=proxies, as_json=True)
    exe_found = False  # Flag pour indiquer la découverte d'un fichier .exe
    for release in releases_dict:
        if exe_found:
            break
        for asset in releases_dict["assets"]:
            if asset["browser_download_url"].endswith(".exe"):
                url_download = asset["browser_download_url"]
                filename = url_download.split("/")[-1]
                exe_found = True  # Mettre à jour le flag pour indiquer qu'un .exe a été trouvé
                break
    if not isfile(filename):
        package_updated = True
        wget(url_download, filename, proxies=proxies)

    # nettoyer les fichiers temporaires
    for f in glob.glob("*.exe"):
        if f != filename:
            remove_file(f)

    last_version = get_file_properties(filename)["ProductVersion"]

    control.set_software_version(last_version)
    control.save_control_to_wapt()

    return package_updated
