# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import json

# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def update_package():
    result = False
    proxies = get_proxies()

    if not proxies:
        proxies = get_proxies_from_wapt_console()
        
    git_repo = "xpipe-io/xpipe"
    url_api = "https://api.github.com/repos/%s/releases/latest" % git_repo   
    # Getting latest version information from official sources
    print("API used is: %s" % url_api)
    json_load = json.loads(wgets(url_api, proxies=proxies))

    for download in json_load["assets"]:
        if download["browser_download_url"].endswith('x86_64.dmg'):
            url_dl = download["browser_download_url"]
            version = json_load["name"]
            filename = download["name"]
            break

    if not isfile(filename):
        package_updated = True
        print(f"Downloading " + filename)
        wget(url_dl,filename,proxies=proxies)

    #nettoyer les fichiers temporaires
    for f in glob.glob('*.dmg'):
        if f != filename:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()