# -*- coding: utf-8 -*-
from setuphelpers import *

def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    api_url = "https://api.github.com/repos/xournalpp/xournalpp/releases/latest"
    releases_dict = wgets(api_url, proxies=proxies, as_json=True)

    for asset in releases_dict["assets"]:
        if asset["browser_download_url"].endswith(".exe"):
            url_download = asset["browser_download_url"]
            latest_bin = asset["name"]
            version = releases_dict["tag_name"][1:]
            break

    # Deleting binaries
    for f in glob.glob("*.exe"):
        if f != latest_bin:
            remove_file(f)

    # Downloading latest binaries
    print("Download URL is: %s" % url_download )
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_download , latest_bin, proxies=proxies)
    else:
        print("EXE file is present: %s" % latest_bin)


    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated