# -*- coding: utf-8 -*-
from setuphelpers import *


def install():
    # Declaring local variables
    bin_name = glob.glob('xournalpp-*.exe')[0]
    path_to_xournal = makepath(programfiles,"Xournal++","bin","xournalpp.exe")

    if force or not isfile(path_to_xournal) or Version(get_file_properties(path_to_xournal)['ProductVersion']) < control.get_software_version(): 
        install_exe_if_needed(
            bin_name,
            silentflags='/S /allusers',
            min_version= control.get_software_version(),
        )
    else:
        print('Skip Xournal++ already install')

    if not isfile(path_to_xournal) or Version(get_file_properties(path_to_xournal)['ProductVersion']) < control.get_software_version(): 
        error("Xournal++ not install")
    
def uninstall():
    uninstall_exe_path =  makepath(programfiles,'Xournal++','Uninstall.exe')
    if isfile(uninstall_exe_path):
        run(f'"{uninstall_exe_path}" /S')

