# -*- coding: utf-8 -*-
from setuphelpers import *
import re


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    api_url = "https://api.github.com/repos/xournalpp/xournalpp/releases/latest"

     # Get data from API
    releases_dict = wgets(api_url, proxies=proxies, as_json=True)
    zip_found = False  # Flag pour indiquer la découverte d'un fichier .zip
    #target_extension = control.target_os + ".zip"
    for release in releases_dict:
        if zip_found:
            break
        for asset in releases_dict["assets"]:
            if asset["browser_download_url"].endswith("x86_64.AppImage"):
                url_download = asset["browser_download_url"]
                latest_bin = url_download.split('/')[-1]
                last_version = releases_dict["name"][10:]
                zip_found = True  # Mettre à jour le flag pour indiquer qu'un .zip a été trouvé
                break


   
    # Deleting binaries
    for f in glob.glob("*.AppImage"):
        if f != latest_bin:
            remove_file(f)


    # Downloading latest binaries
    print("Download URL is: %s" % url_download )
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(url_download , latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)
    
    # Updating the package
    control.set_software_version(last_version)
    control.save_control_to_wapt()

    return package_updated