# -*- coding: utf-8 -*-
##################################################
# This file is part of WAPT Enterprise
# All right reserved, (c) Tranquil IT Systems 2024
# For more information please refer to
# https://wapt.tranquil.it/store/licences.html
##################################################
from setuphelpers import *
from setupdevhelpers import *
import waptlicences


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name

    # All download available here : https://www.withsecure.com/en/support/download
    download_url = "https://download.withsecure.com/PSB/latest/ElementsAgentOfflineInstaller.msi"
    latest_bin = download_url.rsplit("/", 1)[-1]
    latest_bin_extension = latest_bin.rsplit(".", 1)[-1]

    print(f"Download URL is: {download_url}")
    
    if isfile(latest_bin):
        remove_file(latest_bin)
        
    print(f"Downloading: {latest_bin}")
    wget(download_url, latest_bin, proxies=proxies)

    expected_issuer = "WithSecure Oyj"
    sign_name = waptlicences.check_msi_signature(latest_bin)[0]
    if sign_name != expected_issuer:
        error(f'Bad issuer {sign_name} != {expected_issuer} ')
        
    version = get_msi_properties(latest_bin)['ProductVersion']
    print(f"Latest {app_name} version is: {version}")

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    for f in glob.glob(f'*.{latest_bin_extension}'):
        if f != latest_bin:
            remove_file(f)

    control.set_software_version(version)
    control.save_control_to_wapt()

    return package_updated