# -*- coding: utf-8 -*-
from setuphelpers import *

def install():
    bin_name = glob.glob("ElementsAgentOfflineInstaller.msi")[0]
    
    # All MSI property : https://www.withsecure.com/userguides/product.html?business/psb-portal/latest/en/concept_zh2_rfh_4bc-psb-portal-latest-en
    properties={
        # "VOUCHER": ""
    }
    
    props = ' '.join(["%s=%s" % (k, v) for (k, v) in properties.items()])
    killalltasks(ensure_list(control.impacted_process))
    run(f'"{makepath(system32(), "msiexec.exe")}" /norestart /q /i "{bin_name}" {props}')
    wait_uninstallkey_present(name="^WithSecure. Elements Agent$")

def uninstall():

    for to_uninstall in installed_softwares(name="^WithSecure. Elements Agent$"):
        print(f"Removing: {to_uninstall['name']} ({to_uninstall['version']})")
        killalltasks(ensure_list(control.impacted_process))
        run(rf'{to_uninstall["uninstall_string"]} --silent')
        wait_uninstallkey_absent(name="^WithSecure. Elements Agent$")
    