# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
{
   "key":"Waterfox 115.15.0 (x64 en-US)",
   "name":"Waterfox (x64 en-US)",
   "version":"G6.0.18",
   "install_date":"",
   "install_location":"C:\\Program Files\\Waterfox",
   "uninstall_string":"\"C:\\Program Files\\Waterfox\\uninstall\\helper.exe\"",
   "publisher":"BrowserWorks Ltd",
   "system_component":0,
   "win64":true
  }

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls

app_name = "Waterfox"

def install():
    # Declaring local variables
    bin_name = glob.glob('Waterfox Setup *.exe')[0]
    # Installing the software
    install_exe_if_needed(bin_name,
        silentflags='/S',
        key= "",
        min_version=control.get_software_version(),
        get_version=get_version,
        timeout=600,
    )


def get_version(app_registry_dict):
    return app_registry_dict["version"].replace("G","")

def uninstall() :
    # Uninstalling the software
    for to_uninstall in installed_softwares(app_name):
        print("Removing: %s (%s)" % (to_uninstall["name"], to_uninstall["version"]))
        killalltasks(ensure_list(control.impacted_process))
        run(uninstall_cmd(to_uninstall["key"]))
        wait_uninstallkey_absent(to_uninstall["key"])