#!/bin/bash
##
## -----------------------------------------------------------------
##    This file is part of WAPT Software Deployment
##    Copyright (C) 2012 - 2024  Tranquil IT https://www.tranquil.it
##    All Rights Reserved.
##
##    WAPT helps systems administrators to efficiently deploy
##    setup, update and configure applications.
## ------------------------------------------------------------------
##
set -e
if [[ "$OSTYPE" == "darwin"* ]]; then
    export LC_ALL=en_US.UTF-8
    export LANG=en_US.UTF-8
    OLD_PWD=`pwd`
    TARGET=$0
    cd `dirname $TARGET`
    TARGET=`basename $TARGET`
    while [ -L "$TARGET" ]
    do
        TARGET=`readlink $TARGET`
        cd `dirname $TARGET`
        TARGET=`basename $TARGET`
    done
    WAPT_HOME=`pwd -P`
    cd $OLD_PWD
else
	WAPT_HOME="$(dirname "$(readlink -f "$0")")"
fi
CRYPTOGRAPHY_OPENSSL_NO_LEGACY=1 PYTHONNOUSERSITE=1 NCURSES_NO_UTF8_ACS=1 PYTHONPATH="${WAPT_HOME}" "${WAPT_HOME}"/bin/python -I $@
