#!/bin/bash
##
## -----------------------------------------------------------------
##    This file is part of WAPT Software Deployment
##    Copyright (C) 2012 - 2024  Tranquil IT https://www.tranquil.it
##    All Rights Reserved.
##
##    WAPT helps systems administrators to efficiently deploy
##    setup, update and configure applications.
## ------------------------------------------------------------------
##
SERVICE_WAS_RUNNING=false
if [[ "$OSTYPE" == "darwin"* ]]; then
    SERVICE="com.tranquilit.tis-waptagent"
    OLD_PWD=`pwd`
    TARGET=$0
    cd `dirname $TARGET`
    TARGET=`basename $TARGET`
    while [ -L "$TARGET" ]
    do
        TARGET=`readlink $TARGET`
        cd `dirname $TARGET`
        TARGET=`basename $TARGET`
    done
    WAPT_HOME=`pwd -P`
    cd $OLD_PWD
    if sudo launchctl list | grep -Fq $SERVICE; then
        SERVICE_WAS_RUNNING=true
        sudo launchctl unload -w /Library/LaunchDaemons/$SERVICE.plist
    fi
else
    SERVICE="waptservice"
    WAPT_HOME="$(dirname "$(readlink -f "$0")")"
    if systemctl list-units --full -all | grep -Fq $SERVICE && systemctl is-active --quiet $SERVICE; then
        SERVICE_WAS_RUNNING=true
        sudo systemctl stop --quiet $SERVICE
    fi
fi
sudo "${WAPT_HOME}/wapt-get.bin" --peercache "${WAPT_HOME}/waptservice/service.py" $@
if $SERVICE_WAS_RUNNING; then
    if [[ "$OSTYPE" == "darwin"* ]]; then
        sudo launchctl load -w /Library/LaunchDaemons/$SERVICE.plist
    else
        sudo systemctl start --quiet $SERVICE
    fi
fi
