# -*- coding: utf-8 -*-
from waptpackage import PackageEntry
from setuphelpers import *
import json

def update_package():
    data = json.loads(wgets('https://wapt.tranquil.it/wapt/releases/latest/wapt_agent_list.json'))

    for entry in data:
        p = PackageEntry()
        p.package = 'tis-waptupgrade'
        p.min_os_version = entry['wapt_min_os_version']
        p.max_os_version = entry['wapt_max_os_version']
        p.target_os = entry['wapt_target_os']
        p.architecture = entry['wapt_architecture']

        if "tis-waptagent-gui" in entry['url'] :
            continue

        if not WAPT.host_capabilities().is_matching_package(p):
            continue

        matchentry = entry
        break

    wget(matchentry['url'],matchentry['url'].split('/')[-1],sha256=matchentry['file_sha256'])

    control.target_os = matchentry['wapt_target_os']
    control.min_os_version = matchentry['wapt_min_os_version']
    control.max_os_version = matchentry['wapt_max_os_version']
    control.architecture = matchentry['wapt_architecture']
    control.set_software_version(matchentry['wapt_version'])
    control.save_control_to_wapt()


