# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    
    name_pypi = "pip"
    wanted_file = "py3-none-any.whl"
    
    api_url = f"https://pypi.org/pypi/{name_pypi}/json"

    data = wgets(api_url, proxies=proxies, as_json=True)
    version = data['info']['version']
    latest_release_binaries = data['releases'][version]

    for f in latest_release_binaries:
        if not f['yanked'] and f['url'].endswith(wanted_file):
            download_url = f['url']
            sumsha256 = f['digests']['sha256']
            break

    whl = download_url.split('/')[-1]
    
    wget(download_url, whl, sha256=sumsha256, proxies=proxies)

    for f in glob.glob('*.whl'):
        if f != whl:
            remove_file(f)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print(f"Software version updated (from: {control.get_software_version()} to: {Version(version)})")
        package_updated = True
    else:
        print(f"Software version up-to-date ({Version(version)})")

    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return package_updated