# -*- coding: utf-8 -*-
from setuphelpers import *
import glob


def install():

    if is_redhat_based():
        waptagent_package_file = glob.glob('*.rpm')[0]
        install_rpm(waptagent_package_file)
    else:
        install_apt('xdg-utils')
        install_apt('desktop-file-utils')
        waptagent_package_file = glob.glob('*.deb')[0]
        install_deb(waptagent_package_file)


def uninstall():
    if is_redhat_based():
        uninstall_yum('tis-waptagent-gui')
    else:
        uninstall_apt('tis-waptagent-gui')