# -*- coding: utf-8 -*-
from setuphelpers import *

bin_name = "chromedriver"


def install():
    path_selenium = makepath(WAPT.wapt_base_dir, "selenium")
    mkdirs(path_selenium)
    filecopyto(glob.glob(f"*{bin_name}*")[0], path_selenium)


def uninstall():
    path_selenium = makepath(WAPT.wapt_base_dir, "selenium")
    # removing binary
    glob_path = makepath(path_selenium, bin_name + "*")
    for bin_to_delete in glob.glob(glob_path):
        print(f"removing {bin_to_delete}")
        remove_file(bin_to_delete)

    # cleaning folder if empty
    if isdir(path_selenium):
        if dir_is_empty(path_selenium):
            print(f"{path_selenium} is empty removing folder")
            remove_tree(path_selenium)
        else:
            print(f"{path_selenium} is not empty")


def audit():
    # Declaring local variables
    package_version = control.version.split("-", 1)[0]

    # Getting installed software version
    if installed_softwares(name=r"\bGoogle Chrome\b"):
        chrome_version = installed_softwares(name=r"\bGoogle Chrome\b")[0]["version"]
    else:
        chrome_version = None

    # Auditing software
    if chrome_version != package_version:
        print(
            f"your browser version is {chrome_version}, the driver version is {package_version}, if the versions are too different you may encounter issues"
        )
    return "OK"
