# -*- coding: utf-8 -*-
from setuphelpers import *


bin_name = "chromedriver.exe"


def install():
    zip_name = glob.glob("chromedriver-*.zip")[0]
    zip_dir = zip_name.split(".zip")[0]
    unzip(zip_name, ".", f"{zip_dir}/{bin_name}", False)

    selenium_wapt_dir = makepath(WAPT.wapt_base_dir, "selenium")
    mkdirs(selenium_wapt_dir)
    driver_path = makepath(selenium_wapt_dir, bin_name)
    print(f'Copying: "{driver_path}" ({control.get_software_version()})')
    filecopyto(bin_name, selenium_wapt_dir)

    if not installed_softwares(name="^Google Chrome$") and not params.get("running_as_luti"):
        print(f'ERROR: You must install Google Chrome to use {control.name}\nYou can use the package "tis-chrome" for example')


def audit():
    # Declaring local variables
    audit_result = "OK"
    app_check = installed_softwares(name="^Google Chrome$")
    audit_version = True

    # Auditing software
    if not app_check and not params.get("running_as_luti"):
        print("%s is not installed" % control.package.split("-", 1)[-1].replace("-", " ").title())
        audit_result = "ERROR"
    elif audit_version:
        for to_audit in app_check:
            if Version(to_audit["version"], 1) != Version(control.get_software_version(), 1):
                print(
                    f'{to_audit["name"]} version is: {to_audit["version"]} and {control.name} version is: {control.get_software_version()}\n{control.name} may not work.'
                )
                audit_result = "WARNING"

    # audit_result = "OK"  # No longer return status since this package will be included in tis-wapt-selenium
    return audit_result


def uninstall():
    selenium_wapt_dir = makepath(WAPT.wapt_base_dir, "selenium")
    driver_path = makepath(selenium_wapt_dir, bin_name)
    if isfile(driver_path):
        print(f'Removing: "{driver_path}"')
        remove_file(driver_path)
    if dir_is_empty(selenium_wapt_dir):
        print(f'Removing: "{selenium_wapt_dir}"')
        remove_tree(selenium_wapt_dir)
