# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    api_url = "https://googlechromelabs.github.io/chrome-for-testing/last-known-good-versions-with-downloads.json"
    download_dict = {
        "windows-x64": "win64",
        "windows-x86": "win32",
        "windows-all": "win32",
        "debian(>8),ubuntu,redhat_based-all": "linux64",
        "darwin-all": "mac-x64",
        "darwin-x64": "mac-x64",
        "darwin-arm64": "mac-arm64",
    }
    download_str = download_dict[control.target_os + "-" + ensure_list(control.architecture)[0]]

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = wgets(api_url, proxies=proxies, as_json=True)["channels"]["Stable"]
    version = json_load["version"]
    for to_download in json_load["downloads"]["chromedriver"]:
        if to_download["platform"] == download_dict[control.target_os + "-" + ensure_list(control.architecture)[0]]:
            download_url = to_download["url"]
            latest_bin = to_download["url"].split("/")[-1]
            break

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Deleting outdated binaries
    remove_outdated_binaries(latest_bin, "zip")
    # arch_list = ensure_list(control.architecture)
    # remove_outdated_binaries(version, filename_contains=("x64" if "x64" in arch_list else "x86" if "x86" in arch_list else []))

    # # Checking version from file
    # if get_os_name() == "Windows" and "windows" in control.target_os.lower():
    #     version_from_file = get_version_from_binary(latest_bin)
    #     if Version(version_from_file, 4) == Version(version, 4):
    #         print(f"INFO: Binary file version ({version_from_file}) corresponds to online version ({version})")
    #     else:
    #         error(f"ERROR: Binary file version ({version_from_file}) do NOT corresponds to online version ({version})")

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Validating update-package-sources
    return package_updated

    # # Changing version of the package and validating update-package-sources
    # return complete_control_version(control, version)
