# -*- coding: utf-8 -*-

from setupdevhelpers import *
from waptutils import CustomZipFile
from waptutils import create_recursive_zip

import distro
import platform
import tarfile
import json
import subprocess
import datetime
import sys
sys.path.append('.')
from get_cots import download_cots, get_cots_version, get_cots_filename

python_name_file = str(platform.system().lower() + '_' + platform.machine().lower() + '_' .strip('_'))
download_directory = r'c:\tranquilit'




def update_package():
    if platform.system() =='Linux':
        update_package_linux()
        return
    elif platform.system() =='Windows':
        update_package_windows()
        return
    elif platform.system() == 'Darwin':
        update_package_macos()
    else:
        print('non supported os')
        raise()

def update_package_linux():
    unix_python_dir='/opt/wapt'
    print("[UTC %s] start building chroot env" % datetime.datetime.utcnow())
    if type_debian():
        subprocess.run('bash step1_prepare_debian_chroot.sh %s' % unix_python_dir, shell=True, stderr=sys.stdout, stdout=open('/root/compile_python.log','w'))
    elif type_redhat():
        subprocess.run('bash step1_prepare_redhat_chroot.sh %s' % unix_python_dir, shell=True, stderr=sys.stdout, stdout=open('/root/compile_python.log','w'))

    print("[UTC %s] start downloading cots" % datetime.datetime.utcnow())
    download_cots(download_directory=r'/root/python_build_chroot/root/')

    print("[UTC %s] start compiling python" % datetime.datetime.utcnow())
    filecopyto('step2_compile_python_in_chroot.sh','/root/python_build_chroot/root/')
    subprocess.run('chroot /root/python_build_chroot /bin/bash /root/step2_compile_python_in_chroot.sh  %s' % unix_python_dir, shell=True, stderr=sys.stdout, stdout=open('/root/compile_python.log','a'))

    print("[UTC %s] targzipping python distrib" % datetime.datetime.utcnow())
    run('tar -zcf %s/python-%s.tar.gz -C /root/python_build_chroot/%s .' % (basedir, python_name_file, unix_python_dir))

    if params:
        commit_count = params.get("commit_count",0)
    else:
        val = subprocess.check_output('git rev-list --count HEAD', shell=True)
        commit_count = int(val)
    control.version = "%s-%s" % (control.version.split('-')[0], commit_count)
    control.save_control_to_wapt()

def print_utc(message):
    print("[UTC %s] %s" % (datetime.datetime.utcnow(), message))

def update_package_windows():

    print_utc("start building")

    #remove linux specific files from include dir
    remove_file('*.sh')

    print_utc("start downloading cots")
    download_cots(download_directory=basedir)

    #Download and extract python source
    python_version_from_control = control.version.split('-')[0]
    python_version_from_sbom = get_cots_version('Python')
    if python_version_from_control !=python_version_from_sbom:
        raise Exception('Different version in sbom and in control file, please check')
    python_version = python_version_from_sbom

    unzip_with_7zip(f'Python-{python_version}.tgz',f'Python-{python_version}-tar')
    unzip_with_7zip(rf'Python-{python_version}-tar\Python-{python_version}.tar','.')

    remove_tree(f'Python-{python_version}-tar')
    remove_file(f'Python-{python_version}.tgz')

    #Download and extract openssl source
    openssl_version =get_cots_version('openssl')
    unzip_with_7zip(rf'openssl-{openssl_version}.tar.gz',rf'openssl-{openssl_version}-tar')
    unzip_with_7zip(rf'openssl-{openssl_version}-tar\openssl-{openssl_version}.tar','.')
    remove_tree(rf'openssl-{openssl_version}-tar')
    remove_file(rf'openssl-{openssl_version}.tar.gz')

    if not isfile(r'C:\Program Files\NASM\nasm.exe'):
        error(r'C:\Program Files\NASM\nasm.exe not found')

    print_utc("running get_external.bat")
    run(rf'Python-{python_version}\PCbuild\get_externals.bat',timeout=5000)

    with open(rf'openssl-{openssl_version}\Configurations\60-custom.conf','w') as f:
        f.write(data_custom)

    add_to_system_path(r'C:\Program Files\NASM')

    print_utc("compiling openssl")
    run(rf'cd openssl-{openssl_version} & set path=C:\Program Files\NASM;%path% &"C:\Program Files (x86)\Microsoft Visual Studio\2019\BuildTools\VC\Auxiliary\Build\vcvars32.bat" &"C:\Strawberry\perl\bin\perl.exe" configure VC-WIN32-rtt & nmake',timeout=7200)

    name_openssl_folder = glob.glob(rf'Python-{python_version}\externals\openssl-bin-*')[0].split('\\')[-1]

    shutil.move(rf'Python-{python_version}\externals\{name_openssl_folder}\win32',rf'Python-{python_version}\externals\{name_openssl_folder}\win32old')
    shutil.move(rf'openssl-{openssl_version}',rf'Python-{python_version}\externals\{name_openssl_folder}\win32')
    filecopyto(rf'Python-{python_version}\externals\{name_openssl_folder}\win32old\include\applink.c',rf'Python-{python_version}\externals\{name_openssl_folder}\win32\include\applink.c')

    with open(makepath(f'Python-{python_version}','PCbuild','openssl.props'), 'r') as f:
        data=f.read()
    data = data.replace(r"<_DLLSuffix>-1_1</_DLLSuffix>",r"<_DLLSuffix>-3</_DLLSuffix>")
    with open(makepath(f'Python-{python_version}','PCbuild','openssl.props'), 'w') as f:
        f.write(data)

    #Disable VENV_REDIRECT
    for vcxproj in ['venvlauncher.vcxproj','venvwlauncher.vcxproj']:
        with open(makepath(f'Python-{python_version}','PCbuild',vcxproj), 'r') as f:
            data=f.read()
        data = data.replace(r";VENV_REDIRECT;",r";")
        with open(makepath(f'Python-{python_version}','PCbuild',vcxproj), 'w') as f:
            f.write(data)

    print_utc("compiling python")
    run(rf'Python-{python_version}\PCbuild\build.bat -p Win32 -t Rebuild',timeout=5000)

    print_utc("packaging python")
    run(rf'"C:\Program Files (x86)\Microsoft Visual Studio\2019\BuildTools\MSBuild\Current\Bin\msbuild.exe" "%s\Python-{python_version}\Tools\msi\make_zip.proj" /t:Build   /p:OutputPath="%s"' % (basedir,basedir))

    name_generate = glob.glob('*.zip')[0]
    os.rename(name_generate,'Python-%s-x86.zip' % python_name_file)

    remove_tree(f'Python-{python_version}')
    remove_file('*.tar.gz')
    remove_file('*.tar.xz')
    remove_file('*.tar.bz2')

    commit_count = params.get("commit_count",0)
    control.version = "%s-%s" % (Version(python_version), commit_count)
    control.save_control_to_wapt()



data_custom = r"""## -*- mode: perl; -*-
## Personal configuration targets

my %targets = (
    "VC-WIN32-rtt" => {
        inherit_from     => [ "VC-WIN32" ],
        cflags           => sub{my $v=pop; $v=~ s/\/MD/\/MT/ig; return $v},
        lflags           => "/nologo /release",
    },
    "VC-WIN64A-rtt" => {
        inherit_from     => [ "VC-WIN64A" ],
        cflags           => sub{my $v=pop; $v=~ s/\/MD/\/MT/ig; return $v},
        lflags           => "/nologo /release",
    },
);"""


def update_package_macos():
    unix_python_dir = '/opt/python311'

    print("[UTC %s] start downloading cots" % datetime.datetime.utcnow())
    download_cots(download_directory=r'/var/root/')

    print("[UTC %s] start compiling python" % datetime.datetime.utcnow())
    filecopyto('step2_compile_python_macos.sh','/var/root/')
    subprocess.run('/bin/bash step2_compile_python_macos.sh %s' % unix_python_dir, shell=True, stderr=sys.stdout, stdout=open('/var/root/compile_python.log','a'))


    # should it be done for *.dylib also?
    # should add more glob.glob for lib version evolution
    for filename in glob.glob(os.path.join('opt','python311','lib') + "/**/*.so",recursive=True):
        cmd = '/usr/bin/install_name_tool -rpath  /opt/python311/lib/ /opt/wapt/lib/  %s' % filename
        print("Updating rpath : %s " % cmd)
        try:
            run(cmd)
        except:
            print('error while changing rpath on %s ' % filename)

    run('/usr/bin/install_name_tool -change libsqlite3.dylib /opt/wapt/lib/libsqlite3.dylib %s ' % os.path.join('/','opt','wapt','lib','python3.11', 'lib-dynload','_sqlite3.cpython-310-darwin.so'))


    print("[UTC %s] targzipping python distrib" % datetime.datetime.utcnow())
    run('tar -zcf %s/python-%s.tar.gz -C /opt/python311 .' % (basedir, python_name_file))

    if params:
        commit_count = params.get("commit_count",0)
    else:
        val = subprocess.check_output('git rev-list --count HEAD', shell=True)
        commit_count = int(val)
    control.version = "%s-%s" % (control.version.split('-')[0], commit_count)
    control.save_control_to_wapt()



