#!/bin/bash
set -e

PREFIX="$1"

if [ -z "$PREFIX"  ]; then
        PREFIX='/opt/wapt/'
fi


if [ -n "$PREFIX"  ]; then
	PREFIX='/opt/wapt/'
fi



export LANG=C

mkdir -p $PREFIX


function build_openssl {
    cd /root
    tar -zxvf openssl-*.tar.gz
    cd openssl-*/
    ./config --prefix=$PREFIX  -Wl,-rpath,$PREFIX/lib/ --libdir=$PREFIX/lib --openssldir=/etc/ssl/certs/
    make -j`nproc`  
    make install_sw  
}

function build_libp11 {
    cd /root
    tar -zxvf libp11-*.tar.gz
    cd libp11-*/
    ./configure --prefix=$PREFIX \
        CFLAGS="-std=c99" \
        LDFLAGS="-Wl,-rpath,$PREFIX/lib/ -L$PREFIX/lib" \
        CPPFLAGS="-I$PREFIX/include" \
        PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig/
    make install
}

function build_libffi {
    cd /root
    tar -zxvf libffi-*.tar.gz 
    cd libffi-*/
    ./configure --prefix=$PREFIX -C   LDFLAGS="-Wl,-rpath,$PREFIX/lib/" PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig
    make
    cp -a */.libs/libffi.so* $PREFIX/lib/
    cp -a */.libs/libffi.a $PREFIX/lib/
    cp -a */libffi.pc  $PREFIX/lib/pkgconfig/
    cp -a ./include/* $PREFIX/include
    cp -a ./*/include/* $PREFIX/include
}

function build_libsqlite {
    cd /root
    tar -xvf  sqlite-autoconf-*.tar.gz
    cd sqlite-autoconf-*/
    ./configure --prefix=$PREFIX LDFLAGS="-Wl,-rpath,$PREFIX/lib/" PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig --enable-shared CFLAGS="-DTCLSH=0"
    make
    make install
}

function build_libpq {
    cd /root
    tar -xvf postgresql-*.tar.gz
    cd postgresql-*/
    ./configure --prefix=$PREFIX -C --with-openssl  LDFLAGS="-Wl,-rpath,$PREFIX/lib/ -L$PREFIX/lib" PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig --without-readline --with-ssl=$PREFIX/lib --with-libraries=$PREFIX/lib --with-includes=$PREFIX/include/ CFLAGS="-I$PREFIX/include"
    make
    cp -a ./src/interfaces/libpq/libpq.so.* $PREFIX/lib 
    cp -a ./src/interfaces/libpq/libpq.a $PREFIX/lib
    cp -a ./src/interfaces/libpq/libpq.pc $PREFIX/lib/pkgconfig
    rsync -aP ./src/include/libpq/ $PREFIX/include/libpq/
    rsync -aP ./src/interfaces/libpq/*.h $PREFIX/include/
}

function build_libkrb5 {
    cd /root
    tar -zxvf krb5-*.tar.gz
    cd krb5-*/src/
    ./configure  --prefix=$PREFIX LDFLAGS="-Wl,-rpath,$PREFIX/lib/" PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig/ 
    make -j`nproc` 
    make install 
}



function build_tirpc {
    cd /root
    tar -xvf libtirpc-*.tar.bz2
    cd libtirpc-*/
    export PATH=$PREFIX/bin:$PATH
    ./configure --prefix=$PREFIX -C    LDFLAGS="-Wl,-rpath,$PREFIX/lib/" PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig CFLAGS="-I $PREFIX/include"
    make
    make install 
    rsync -aP tirpc/ $PREFIX/include/tirpc/
}


function build_libnsl {
    cd /root
    tar -xvf libnsl-*.tar.xz
    cd libnsl-*/
    ./configure --prefix=$PREFIX -C    LDFLAGS="-Wl,-rpath,$PREFIX/lib/" PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig CFLAGS="-I $PREFIX/include"
    make
    cp -a src/.libs/libnsl.so* $PREFIX/lib/
    cp -a src/.libs/libnsl.a $PREFIX/lib/
}

function build_libxcrypt {
    cd /root
    tar -xvf libxcrypt-*.tar.xz
    cd libxcrypt-*/
    ./configure --prefix=$PREFIX --enable-obsolete-api=yes --enable-hashes=all LDFLAGS="-Wl,-rpath,$PREFIX/lib/" PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig
    make -j$(nproc)
    make install
}

function build_libreadline {
    cd /root 
    tar -zxvf readline-*.tar.gz
    cd readline-*/
    ./configure --prefix=$PREFIX -C   LDFLAGS="-Wl,-rpath,$PREFIX/lib/" PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig
    make
    cp -a shlib/libreadline.so.8.3 $PREFIX/lib/
    cp -a readline.pc $PREFIX/lib/pkgconfig
}

function build_libgdbm {
    cd  /root
    tar -zxvf gdbm-*.tar.gz
    cd gdbm-*/
    ./configure --prefix=$PREFIX -C   LDFLAGS="-Wl,-rpath,$PREFIX/lib/" PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig
    make
    cp ./src/.libs/libgdbm.so.6.0.0 $PREFIX/lib
}

function build_python {
    cd /root
    tar -zxvf Python-*.tgz
    cd Python-*/
    ./configure --prefix=$PREFIX -C --with-openssl=$PREFIX/ --enable-shared LDFLAGS="-Wl,-rpath,$PREFIX/lib/" PKG_CONFIG_PATH=$PREFIX/lib/pkgconfig/
    make  altinstall 
    rm -f $PREFIX/bin/{2to3*,idle3*,pydoc*} 
    rm -Rf $PREFIX/etc/
    ln -s $PREFIX/bin/python3.11 $PREFIX/bin/python3
    ln -s $PREFIX/bin/python3.11 $PREFIX/bin/python
}


function cleanup {
    rm -f $PREFIX/bin/{gss-client,k5srvutil,kadmin,kdestroy,kinit,klist,kpasswd,ksu,kswitch,ktutil,kvno,sclient,sim_client,uuclient}
    rm -Rf $PREFIX/{sbin,share,var}
    rm -Rf $PREFIX/lib/python3.*/test
}


build_openssl
build_libp11
build_libffi
build_libsqlite
build_libpq
build_libkrb5
build_tirpc
build_libnsl
build_libxcrypt
build_libreadline
build_libgdbm
build_python
cleanup

exit

