#/bin/bash

set -e

CHROOT_DIR=/root/python_build_chroot

umount ${CHROOT_DIR}/dev  || true
umount ${CHROOT_DIR}/sys/ || true
umount ${CHROOT_DIR}/proc || true

rm -Rf ${CHROOT_DIR}

dnf  --releasever=7 --config=dnf_centos7.conf --installroot=${CHROOT_DIR}  --disablerepo=* --enablerepo=base -y install  systemd centos-release  passwd  yum nss-softokn-freebl  
mount --bind /dev ${CHROOT_DIR}/dev
mount --bind /sys ${CHROOT_DIR}/sys/
mount -t proc none ${CHROOT_DIR}/proc


rm -f ${CHROOT_DIR}/etc/yum.repos.d/{CentOS*.repo,epel*.repo}
cp dnf_centos7.conf ${CHROOT_DIR}/etc/yum.repos.d/base.repo
cp /etc/resolv.conf ${CHROOT_DIR}/etc/resolv.conf

cp step2_compile_python_in_chroot.sh ${CHROOT_DIR}/root

rm -f ${CHROOT_DIR}/etc/yum.repos.d/{CentOS*.repo,epel*.repo}
dnf  --releasever=7 --config=dnf_centos7.conf --installroot=${CHROOT_DIR}  --disablerepo=* --enablerepo=base -y install byacc autoconf automake rsync libtool pkgconfig  perl-IPC-Cmd tcl-devel  perl  perl-IPC-Cmd perl-Time-Piece make zlib-devel bzip2 wget cmake bzip2-devel libffi-devel 
rm -f ${CHROOT_DIR}/etc/yum.repos.d/CentOS*.repo
