#!/bin/bash
set -e

if [ "$#" -ne 2 ]; then
    echo "need 2 parameters : python_version and openssl_version"
    echo "example : 3.11.14 3.5.4"
    exit
fi

python_version="$1"
openssl_version="$2"

export LANG=C

rm -Rf /opt/wapt/

yum install byacc autoconf automake rsync libtool pkg-config sqlite-devel.x86_64 libsqlite3x.x86_64 xz-devel lzma bzip2-devel perl-IPC-Cmd tcl-devel readline-devel -y

#make and install openssl
cd /root
tar -zxvf openssl-${openssl_version}.tar.gz
cd openssl-${openssl_version}
./config --prefix=/opt/wapt  -Wl,-rpath,/opt/wapt/lib/ --libdir=/opt/wapt/lib
make -j`nproc`  >> /root/debug_compile_python 2>&1
make install_sw  >> /root/debug_compile_python 2>&1

#compile p11
cd /root
tar -zxvf libp11-0.4.16.tar.gz
cd libp11-libp11-0.4.16
./bootstrap
./configure --prefix=/opt/wapt \
    CFLAGS="-std=c99" \
    LDFLAGS="-Wl,-rpath,/opt/wapt/lib/ -L/opt/wapt/lib" \
    CPPFLAGS="-I/opt/wapt/include" \
    PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig/
make install 

#libffi
cd /root
tar -zxvf libffi-3.5.2.tar.gz 
cd libffi-3.5.2
./configure --prefix=/opt/wapt -C   LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig
make
cp -a */.libs/libffi.so* /opt/wapt/lib/
cp -a */.libs/libffi.a /opt/wapt/lib/
cp -a */libffi.pc  /opt/wapt/lib/pkgconfig/
cp -a ./include/* /opt/wapt/include
cp -a ./*/include/* /opt/wapt/include

#libsqlite
cd /root
tar -xvf sqlite.tar.gz
cd sqlite-product-3500400
./configure --disable-tcl --prefix=/opt/wapt LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig --enable-shared CFLAGS="-DTCLSH=0"
make
make install

#libpq
cd /root
tar -xvf postgresql-15.14.tar.bz2
cd postgresql-15.14
./configure --prefix=/opt/wapt -C --with-openssl  LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig --without-readline --with-ssl=/opt/wapt/lib --with-libraries=/opt/wapt/lib --with-includes=/opt/wapt/include/
make
cp -a ./src/interfaces/libpq/libpq.so.* /opt/wapt/lib 
cp -a ./src/interfaces/libpq/libpq.a /opt/wapt/lib
cp -a ./src/interfaces/libpq/libpq.pc /opt/wapt/lib/pkgconfig
rsync -aP ./src/include/libpq/ /opt/wapt/include/libpq/
rsync -aP ./src/interfaces/libpq/*.h /opt/wapt/include/

#libnsl
# libtirpc-devel contains overlapping xdr.h header with system header and is missing some definition
yum remove -y libtirpc-devel
cd /root
tar -xvf libnsl-2.0.1.tar.xz
cd libnsl-2.0.1
./configure --prefix=/opt/wapt -C   LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig
make
cp -a src/.libs/libnsl.so* /opt/wapt/lib/
cp -a src/.libs/libnsl.a /opt/wapt/lib/


#libxcrypt
cd /root
tar -xvf libxcrypt-4.4.38.tar.xz
cd libxcrypt-4.4.38

./configure --prefix=/opt/wapt --enable-obsolete-api=yes --enable-hashes=all LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig
make -j$(nproc)
make install


#libreadline
cd /root 
tar -zxvf readline-8.3.tar.gz
cd readline-8.3/
./configure --prefix=/opt/wapt -C   LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig
make
cp -a shlib/libreadline.so.8.3 /opt/wapt/lib/
cp -a readline.pc /opt/wapt/lib/pkgconfig

#gdbm
cd  /root
tar -zxvf gdbm-1.26.tar.gz
cd gdbm-1.26/
./configure --prefix=/opt/wapt -C   LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig
make
cp ./src/.libs/libgdbm.so.6.0.0 /opt/wapt/lib


cd /root
#wget https://www.python.org/ftp/python/${python_version}/Python-${python_version}.tgz
tar -zxvf Python-${python_version}.tgz
cd Python-${python_version}
./configure --prefix=/opt/wapt -C --with-openssl=/opt/wapt/ --enable-optimizations --enable-shared LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig/
make -j`nproc` install >> /root/debug_compile_python 2>&1
rm -f /opt/wapt/bin/{2to3,2to3-3.11,idle3,idle3.11} 

#make and install mit kerberos

cd /root
#wget https://kerberos.org/dist/krb5/1.19/krb5-1.22.1.tar.gz
tar -zxvf krb5-1.22.1.tar.gz
cd krb5-1.22.1/src
./configure  --prefix=/opt/wapt LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig/ 
make -j`nproc` >> /root/debug_compile_python 2>&1
make install >> /root/debug_compile_python 2>&1
rm -f /opt/wapt/bin/{gss-client,k5srvutil,kadmin,kdestroy,kinit,klist,kpasswd,ksu,kswitch,ktutil,kvno,sclient,sim_client,uuclient}
rm -Rf /opt/wapt/{sbin,share,var}
rm -Rf /opt/wapt/lib/python3.11/test
/opt/wapt/bin/python3 -m pip install --upgrade pip
/opt/wapt/bin/python3 -m pip install wheel
PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig/ LANG=C LDFLAGS="-L/opt/wapt/lib" CFLAGS="-I/opt/wapt/include" CPPFLAGS="-I/opt/wapt/include/" /opt/wapt/bin/python3 -m pip install https://files.pythonhosted.org/packages/68/ce/95b0bae7968c65473e1298efb042e10cafc7bafc14d9e4f154008241c91d/cffi-1.16.0.tar.gz

#/opt/wapt/bin/python3 -m pip install whell
#export PATH=$PATH:/opt/wapt/bin/ ; /opt/wapt/bin/python3 -m pip install -r /root/requirements.txt
exit
