#!/bin/bash
set -e

apt-get update -y
apt-get install debootstrap -y

rm -Rf /root/python_build_chroot/

# we need to specify http url instead of https because of out of date certificate authority 
# in buster by default and add security updates repo, otherwise superseeded package don't have
# the most recent supported gpg key signature
debootstrap  buster /root/python_build_chroot/ http://archive.debian.org/debian
cat << EOF > /root/python_build_chroot/etc/apt/sources.list
deb http://archive.debian.org/debian buster main
 
EOF

chroot /root/python_build_chroot/ bash -c "LANG=C apt-get update"

chroot /root/python_build_chroot/ bash -c "LANG=C apt-get install -y autoconf rsync automake libtool pkg-config libpng-dev libfreetype6-dev build-essential libbz2-dev libreadline-dev zlib1g-dev libsqlite3-dev tk-dev libgdm-dev patchelf patch byacc wget locales software-properties-common liblzma-dev lzma libsqlite3-0"

chmod 755 step2_compile_python_in_debootstrap.sh
cp step2_compile_python_in_debootstrap.sh /root/python_build_chroot/root/step2_compile_python_in_debootstrap.sh

