#!/bin/bash
set -e

if [ "$#" -ne 2 ]; then
    echo "need 2 parameters : python_version and openssl_version"
    echo "example : 3.10.19 3.5.4"
    exit
fi


python_version="$1"
openssl_version="$2"

#chroot /root/python_builddir/ bash -c "LANG=C apt-get install software-properties-common -y"
#chroot /root/python_builddir/ bash -c "LANG=C add-apt-repository universe -y "
mkdir /tmp/python_builddir
curl https://github.com/openssl/openssl/releases/download/openssl-${openssl_version}/openssl-${openssl_version}.tar.gz -o /tmp/python_builddir/openssl-${openssl_version}.tar.gz  --insecure -L
curl https://www.python.org/ftp/python/${python_version}/Python-${python_version}.tgz -o /tmp/python_builddir/Python-${python_version}.tgz  --insecure -L
curl https://kerberos.org/dist/krb5/1.22/krb5-1.22.1.tar.gz -o /tmp/python_builddir/krb5-1.22.1.tar.gz  --insecure -L
curl https://netcologne.dl.sourceforge.net/project/lzmautils/xz-5.8.1.tar.xz -o /tmp/python_builddir/xz-5.8.1.tar.gz  --insecure -L
curl https://codeload.github.com/OpenSC/libp11/tar.gz/refs/tags/libp11-0.4.16 -o /tmp/python_builddir/libp11-0.4.16.tar.gz --insecure -L
curl https://www.sqlite.org/src/tarball/sqlite-product-3510000.tar.gz -o /tmp/python_builddir/sqlite.tar.gz  --insecure -L
