# -*- coding: utf-8 -*-
from setupdevhelpers import *
from waptutils import CustomZipFile
from waptutils import create_recursive_zip
import os
import distro
import platform
import time

python_name_file = str(platform.system().lower() + '_' + platform.machine().lower() + '_' + '_'.join([u.split('.')[0] for u in distro.linux_distribution(False) if u][:2])).strip('_')

def update_package():

    colum1 = bs_find_all('https://www.python.org/downloads/source/','div','class',"column")[0].findAll('li')
    versionpython = None
    for entry in colum1:
        if versionpython:
            continue
        if not hasattr(entry,'contents'):
            continue
        for i in entry.contents :
            if not hasattr(i,'contents'):
                continue
            v = [t for t in i.contents if str(t).startswith('Python 3.10')]
            if v:
                versionpython = v[0].split(' ')[1]
                break

    openssl_version = '3.5.1'

    run("chmod a+x *.sh")
    run("bash step1_compile_python.sh %s %s" % (versionpython, openssl_version), timeout=1200)

    if os.system("bash step2_compile_python.sh %s %s" % (versionpython, openssl_version)) != 0:
        error('buildfailed')

    remove_file("step1_compile_python.sh")
    remove_file("step2_compile_python.sh")
    filecopyto('/tmp/python.tar.gz','python-%s.tar.gz' % python_name_file)
    commit_count = params.get("commit_count",0)
    control.version = "%s-%s" % (Version(versionpython), commit_count)
    control.save_control_to_wapt()
