#!/bin/bash
set -e

if [ "$#" -ne 2 ]; then
    echo "need 2 parameters : python_version and openssl_version"
    echo "example : 3.10.19 3.5.4"
    exit
fi

python_version="$1"
openssl_version="$2"

export LANG=C
export MACOSX_DEPLOYMENT_TARGET=10.9
rm -Rf /opt/wapt/
#rm -Rf Python*
#rm -Rf openssl*
#rm -Rf krb5*

#make and install openssl

cd /var/root/python_builddir
tar -zxvf openssl-${openssl_version}.tar.gz
cd openssl-${openssl_version}
./config --prefix=/opt/wapt  -Wl,-rpath,/opt/wapt/lib/  --libdir=/opt/wapt/lib
make -j`nproc` 
make install_sw  

# build libp11
#cd /var/root/python_builddir
#tar -zxvf libp11-0.4.16.tar.gz
#cd libp11-libp11-0.4.16/
#./bootstrap
#./configure --prefix=/opt/wapt LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig/
#make install 


##make and install xz
cd /var/root/python_builddir
#wget https://kerberos.org/dist/krb5/1.19/krb5-1.22.1.tar.gz
tar -zxvf xz-5.2.6.tar.gz
cd xz-5.2.6
./configure -prefix=/opt/wapt LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig/
make install 

#libsqlite
cd /var/root/python_builddir
tar -xvf sqlite.tar.gz
cd sqlite-product-3500400
./configure --prefix=/opt/wapt LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig --enable-shared
make
make install

#make and install python

cd /var/root/python_builddir
#wget https://www.python.org/ftp/python/${python_version}/Python-${python_version}.tgz
tar -zxvf Python-${python_version}.tgz
cd Python-${python_version}
./configure -C  --with-openssl=/opt/wapt/ --enable-optimizations --enable-shared --prefix=/opt/wapt LDFLAGS=-Wl,-rpath,/opt/wapt/lib/
make -j`nproc` install
rm -f /opt/wapt/bin/{2to3,2to3-3.10,idle3,idle3.10} 

#make and install mit kerberos

cd /var/root/python_builddir
#wget https://kerberos.org/dist/krb5/1.19/krb5-1.22.1.tar.gz
tar -zxvf krb5-1.22.1.tar.gz
cd krb5-1.22.1/src
./configure --prefix=/opt/wapt LDFLAGS="-Wl,-rpath,/opt/wapt/lib/" PKG_CONFIG_PATH=/opt/wapt/lib/pkgconfig/
make -j`nproc` 
make install 
rm -f /opt/wapt/bin/{gss-client,k5srvutil,kadmin,kdestroy,kinit,klist,kpasswd,ksu,kswitch,ktutil,kvno,sclient,sim_client,uuclient}
rm -Rf /opt/wapt/{sbin,share,var}
rm -Rf /opt/wapt/lib/python3.10/test
cd /
/usr/bin/tar -zcf /tmp/python.tar.gz -C /opt/wapt/ .

#/opt/wapt/bin/python3 -m pip install whell
#/opt/wapt/bin/python3 -m pip install pyobjc==8.5 --platform macosx_10_9_x86_64
#export PATH=$PATH:/opt/wapt/bin/ ; /opt/wapt/bin/python3 -m pip install -r /root/requirements.txt
