#!/bin/bash
set -e

if [ "$#" -ne 2 ]; then
    echo "need 2 parameters : python_version and openssl_version"
    echo "example : 3.10.19 3.5.4"
    exit
fi

python_version="$1"
openssl_version="$2"

rm -Rf /opt/wapt

wget https://github.com/openssl/openssl/releases/download/openssl-${openssl_version}/openssl-${openssl_version}.tar.gz --directory-prefix=/root
wget https://www.python.org/ftp/python/$1/Python-${python_version}.tgz --directory-prefix=/root
wget https://kerberos.org/dist/krb5/1.22/krb5-1.22.1.tar.gz --directory-prefix=/root
wget https://github.com/OpenSC/libp11/archive/refs/tags/libp11-0.4.16.tar.gz --directory-prefix=/root
wget https://ftp.postgresql.org/pub/source/v15.14/postgresql-15.14.tar.bz2 --directory-prefix=/root
wget https://github.com/libffi/libffi/releases/download/v3.5.2/libffi-3.5.2.tar.gz --directory-prefix=/root
wget https://ftp.gnu.org/gnu/readline/readline-8.3.tar.gz --directory-prefix=/root
wget https://ftp.gnu.org/pub/gnu/gdbm/gdbm-1.26.tar.gz --directory-prefix=/root
wget https://github.com/thkukuk/libnsl/releases/download/v2.0.1/libnsl-2.0.1.tar.xz --directory-prefix=/root
wget https://www.sqlite.org/src/tarball/sqlite-product-3500400.tar.gz -O /root/sqlite.tar.gz
wget https://github.com/besser82/libxcrypt/releases/download/v4.4.38/libxcrypt-4.4.38.tar.xz --directory-prefix=/root
