# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
from common import Wapt

folder_base = r"%s\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment" % programfiles32
list_files = []

arch = "arm64"
# list_arch = ["amd64","arm","arm64","x86"]

dict_boot = {"amd64": "bootx64.efi", "x86": "bootia32.efi", "arm": "bootarm.efi", "arm64": "bootaa64.efi"}

list_files.extend(
        [
        #r"%s\%s\Media\Boot\BCD" % (folder_base, arch),
        r"%s\%s\Media\Boot\boot.sdi" % (folder_base, arch),
        r"%s\%s\Media\EFI\Microsoft\Boot\BCD" % (folder_base, arch),
        #r"%s\%s\Media\bootmgr" % (folder_base, arch),
        r"%s\%s\Media\bootmgr.efi" % (folder_base, arch),
        r"%s\%s\Media\EFI\Boot\%s" % (folder_base, arch, dict_boot[arch]),
        r"%s\%s\WinPE_OCs\WinPE-WMI.cab" % (folder_base, arch),
        r"%s\%s\WinPE_OCs\en-us\WinPE-WMI_en-us.cab" % (folder_base, arch),
        r"%s\%s\WinPE_OCs\WinPE-SecureStartup.cab" % (folder_base, arch),
        r"%s\%s\WinPE_OCs\en-us\WinPE-SecureStartup_en-us.cab" % (folder_base, arch),
        r"%s\%s\WinPE_OCs\WinPE-EnhancedStorage.cab" % (folder_base, arch),
        r"%s\%s\WinPE_OCs\en-us\WinPE-EnhancedStorage_en-us.cab" % (folder_base, arch)
    ]
)

def update_package():

    for file in list_files:
        mkdirs(file.replace(folder_base + "\\", "").rsplit("\\", 1)[0])
        filecopyto(file, file.replace(folder_base + "\\", ""))

    winpe = r"%s\%s\en-us\winpe.wim" % (folder_base, arch)

    temp_winpe = makepath(basedir,arch,"en-us","temp")
    mkdirs(temp_winpe)
    filecopyto(winpe, temp_winpe)

    list_modules = [
            r"%s\%s\WinPE_OCs\WinPE-WMI.cab" % (basedir, arch),
            r"%s\%s\WinPE_OCs\en-us\WinPE-WMI_en-us.cab" % (basedir, arch),
            r"%s\%s\WinPE_OCs\WinPE-SecureStartup.cab" % (basedir, arch),
            r"%s\%s\WinPE_OCs\en-us\WinPE-SecureStartup_en-us.cab" % (basedir, arch),
            r"%s\%s\WinPE_OCs\WinPE-EnhancedStorage.cab" % (basedir, arch),
            r"%s\%s\WinPE_OCs\en-us\WinPE-EnhancedStorage_en-us.cab" % (basedir, arch)
        ]

    temp_winpe_file = makepath(r"%s\%s\en-us\temp\winpe.wim" % (basedir, arch))
    temp_winpe_dir = makepath(r"%s\%s\en-us\temp" % (basedir, arch))
    winpe_path = makepath(r"%s\%s\en-us\winpe.wim" % (basedir, arch))
    winpe_mount = makepath(basedir,"tmp_winpe")

    #Make the temporary mount dir
    mkdirs(winpe_mount)

    #Mount the .wim into the temporary mountdir
    if isdir(winpe_mount):
        print("Mounting WinPE")
        run(f'dism.exe /mount-image /imagefile:"{temp_winpe_file}" /mountdir:"{winpe_mount}" /index:1')

    module_count = 0
    #Add modules to the mounted Wim
    for module in list_modules:
        module_count += 1
        print(f"Install module {module_count}/6")
        run(f'dism.exe /Image:"{winpe_mount}" /Add-Package /PackagePath:"{module}"')

    #Unmount the wim with commit
    print("Unmount WinPE")
    run(f'dism.exe /unmount-image /mountdir:"{winpe_mount}" /commit')

    #Remove the temporary dir
    if dir_is_empty(winpe_mount):
        remove_tree(winpe_mount)

    print("Export de l'image")
    run(f'dism.exe /Export-Image /SourceImageFile:"{temp_winpe_file}" /SourceIndex:1 /DestinationImageFile:{winpe_path}')

    remove_tree(temp_winpe_dir)

    filecopyto(rf'%s\Windows Kits\10\Assessment and Deployment Kit\Deployment Tools\{arch}\BCDBoot\Bootsect.exe' % programfiles32,'Bootsect.exe')

    prefixpkg = control.package.split("-", 1)[0]
    WAPT= Wapt()
    f = WAPT.is_installed("%s-adkwinpe" % prefixpkg)
    version = f.version.split("-")[0]
    control.version = "%s-%s" % (version, control.version.split("-", 1)[-1])
    control.save_control_to_wapt()
