# -*- coding: utf-8 -*-
from setuphelpers import *

# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls

folder_base = r"%s\Windows Kits\10\Assessment and Deployment Kit\Windows Preinstallation Environment" % programfiles32
list_files = []

list_arch = ["arm64"]
# list_arch = ["amd64","arm","arm64","x86"]

dict_boot = {"amd64": "bootx64.efi", "x86": "bootia32.efi", "arm": "bootarm.efi", "arm64": "bootaa64.efi"}

for arch in list_arch:
    list_files.extend(
        [
            #r"%s\%s\Media\Boot\BCD" % (folder_base, arch),
            r"%s\%s\Media\Boot\boot.sdi" % (folder_base, arch),
            r"%s\%s\Media\EFI\Microsoft\Boot\BCD" % (folder_base, arch),
            r"%s\%s\en-us\winpe.wim" % (folder_base, arch),
            #r"%s\%s\Media\bootmgr" % (folder_base, arch),
            r"%s\%s\Media\bootmgr.efi" % (folder_base, arch),
            r"%s\%s\Media\EFI\Boot\%s" % (folder_base, arch, dict_boot[arch]),
            r"%s\%s\WinPE_OCs\WinPE-WMI.cab" % (folder_base, arch),
            r"%s\%s\WinPE_OCs\en-us\WinPE-WMI_en-us.cab" % (folder_base, arch),
            r"%s\%s\WinPE_OCs\WinPE-SecureStartup.cab" % (folder_base, arch),
            r"%s\%s\WinPE_OCs\en-us\WinPE-SecureStartup_en-us.cab" % (folder_base, arch),
            r"%s\%s\WinPE_OCs\WinPE-EnhancedStorage.cab" % (folder_base, arch),
            r"%s\%s\WinPE_OCs\en-us\WinPE-EnhancedStorage_en-us.cab" % (folder_base, arch)
        ]
    )

def install():
    for file in list_files:
        parent_path = file.rsplit("\\", 1)[0]
        if not isdir(parent_path):
            mkdirs(parent_path)
        filecopyto(file.replace(folder_base + "\\", ""), file)



