# -*- coding: utf-8 -*-
from setuphelpers import *
import json

"""
{
"key":"{88DA3577-054F-4CA1-8122-7D820494CFFB}_is1",
"name":"VSCodium",
"version":"1.87.2.24072",
"install_date":"2024-04-03 00:00:00",
"install_location":"C:\\Program Files\\VSCodium\\",
"uninstall_string":"\"C:\\Program Files\\VSCodium\\unins000.exe\"",
"publisher":"VSCodium",
"system_component":0,
"win64":true
}

# Default arguments : addcontextmenufiles,addcontextmenufolders,addtopath,associatewithfiles,!desktopicon,!quicklaunchicon,!runcode
Previous silent_args = '/verysilent /mergetasks="!addcontextmenufiles,!addcontextmenufolders,addtopath,associatewithfiles,!desktopicon,!quicklaunchicon,!runcode"'

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls
bin_contains = "VSCodiumSetup-"
silent_args = '/verysilent /mergetasks="!runcode"'


def install():
    # Declaring local variables
    package_version = control.get_software_version()
    bin_name = glob.glob("%s*.exe" % bin_contains)[0]
    if control.architecture == "x64":
        app_uninstallkey = "{88DA3577-054F-4CA1-8122-7D820494CFFB}_is1"
    else:
        app_uninstallkey = "{E34003BB-9E10-4501-8C11-BE3FAA83F23F}_is1"

    # Installing the software
    install_exe_if_needed(
        bin_name,
        silentflags=silent_args,
        key=app_uninstallkey,
        min_version=package_version,
    )


def session_setup():
    print("Disabling: Telemetry, automatic updates, surveys")

    # Configuration procedure: https://supunkavinda.blog/vscode-editing-settings-json
    # C:\Users\username\AppData\Roaming\VSCodium\User\settings.json

    # Declaring local variables
    user_conf_dir = makepath(user_appdata, "VSCodium", "User")
    user_conf_file = makepath(user_conf_dir, "settings.json")
    user_conf_content = r"""{
    "update.mode": "none",
    "update.enableWindowsBackgroundUpdates": false,
    "update.showReleaseNotes": false,
    "telemetry.telemetryLevel": "off",
    "typescript.surveys.enabled": false,
    "extensions.autoCheckUpdates": false,
    "extensions.autoUpdate": false
}
"""

    user_conf_data = json.loads(user_conf_content)
    if not isdir(user_conf_dir):
        mkdirs(user_conf_dir)
    if not isfile(user_conf_file):
        print("Creating: settings.json in: %s" % user_conf_dir)
        json_write_file(user_conf_file, user_conf_data)
    else:
        new_user_conf_data = json_load_file(user_conf_file)
        new_user_conf_data.update(user_conf_data)
        print("Updating: settings.json in: %s" % user_conf_dir)
        json_write_file(user_conf_file, new_user_conf_data)
