# -*- coding: utf-8 -*-
from setuphelpers import *
import platform
import json

bin_contains = "VSCodium.x64"


def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    repo_git = "VSCodium/vscodium"
    api_url = "https://api.github.com/repos/%s/releases" % repo_git

    version = None
    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    data = json.loads(wgets(api_url, proxies=proxies))
    for json_load in data: 
        if version:
            break
        for download in json_load["assets"]:
            if bin_contains in download["name"] and ".dmg" in download["name"]:
                download_url = download["browser_download_url"]
                version = json_load["tag_name"].replace("v", "")
                latest_bin = download["name"]
                break

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating update-package-sources
    return result
