# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def install():
    app_dir = "/Applications/Visual Studio Code.app"
    bin_name = glob.glob("VSCode-darwin*.zip")[0]

    # Installing the package
    if isdir(app_dir):
        remove_tree(app_dir)

    run("unzip %s -d /Applications/" % bin_name)
    run('chmod -R 755 "%s"' % app_dir)
    run('chown -R root:wheel "%s"' % app_dir)

    # Removing the quarantine bit on the file (set by safari when downloaded from internet)
    run('xattr -d -r com.apple.quarantine "%s"' % app_dir)

    try:
        os.symlink("/Applications/Visual Studio Code.app/Contents/Resources/app/bin/code", "/usr/local/bin/code")
    except:
        print("code is already in PATH")


def uninstall():
    # Uninstalling the package
    uninstall_app("Visual Studio Code.app")


def session_setup():
    print("Disabling: Telemetry, automatic updates, surveys")

    # Configuration procedure: https://supunkavinda.blog/vscode-editing-settings-json
    # C:\Users\username\AppData\Roaming\Code\User\settings.json

    # Initializing variables
    user_conf_dir = makepath(user_home_directory(), "Library", "Application Support", "Code", "User")
    user_conf_file = makepath(user_conf_dir, "settings.json")
    user_conf_content = r"""{
    "update.mode": "none",
    "update.enableWindowsBackgroundUpdates": false,
    "update.showReleaseNotes": false,
    "telemetry.telemetryLevel": "off",
    "typescript.surveys.enabled": false,
    "extensions.autoCheckUpdates": false,
    "extensions.autoUpdate": false
}"""

    user_conf_data = json.loads(user_conf_content.strip(","))
    if not isdir(user_conf_dir):
        mkdirs(user_conf_dir)
    if not isfile(user_conf_file):
        print("Creating: %s" % user_conf_file)
        json_write_file(user_conf_file, user_conf_data)
    else:
        new_user_conf_data = json_load_file(user_conf_file)
        new_user_conf_data.update(user_conf_data)
        print("Updating: %s" % user_conf_file)
        json_write_file(user_conf_file, new_user_conf_data)
