# -*- coding: utf-8 -*-
from setuphelpers import *
import json
import requests
import time

ext_uid_name = "ms-python.python"
ext_publisher = ext_uid_name.split(".")[0]


def update_package():
    # Declaring local variables
    result = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    app_name = control.name
    url = "https://marketplace.visualstudio.com/items?itemName=%s" % ext_uid_name

    # Getting latest version from official sources
    print("URL used is %s" % url)
    for bs_search in bs_find_all(url, "script", "type", "application/json", proxies=proxies):
        if bs_search.string.startswith("{"):
            json_data = json.loads(bs_search.string)
            break
    
    version = json_data["Resources"]["Version"]

    download_url = "https://marketplace.visualstudio.com/_apis/public/gallery/publishers/%s/vsextensions/%s/%s/vspackage" % (
        ext_publisher,
        json_data["Resources"]["ExtensionName"],
        version,
    )
    latest_bin = ext_uid_name + "-%s.vsix" % version

    print("Latest %s version is: %s" % (app_name, version))
    print("Download URL is: %s" % download_url)

    # Downloading latest binaries
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        content = requests.get(download_url, stream=True)
        nb_wait = 0
        max_wait = 3600
        while str(content.status_code) == "429":
            timewait = int(content.headers["Retry-After"])
            print("Wait %s" % timewait)
            nb_wait = nb_wait + timewait
            if nb_wait > max_wait:
                error("Max wait ...")
            time.sleep(timewait)
            content = requests.get(download_url, stream=True)

        with open(latest_bin, "wb") as f:
            for chunk in content.iter_content(chunk_size=1024 * 1024):
                f.write(chunk)

    # Changing version of the package
    if Version(version) > Version(control.get_software_version()):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        result = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.version = "%s-%s" % (Version(version), control.version.split("-", 1)[-1])
    # control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version, "vsix")

    # Validating or not update-package-sources
    return result
