# -*- coding: utf-8 -*-
from setuphelpers import *

r"""
Usable WAPT package functions: install(), uninstall(), session_setup(), audit(), update_package()
{
   "key":"{851FBFF7-5148-40A2-A654-942BE80F5B90}_is1",
   "name":"Visual Leak Detector version 2.5.9",
   "version":"2.5.9",
   "install_date":"2024-09-19 00:00:00",
   "install_location":"C:\\Program Files (x86)\\Visual Leak Detector\\",
   "uninstall_string":"\"C:\\Program Files (x86)\\Visual Leak Detector\\unins000.exe\"",
   "publisher":"VLD Team",
   "system_component":0,
   "win64":false
  }

"""
# Declaring global variables - Warnings: 1) WAPT context is only available in package functions; 2) Global variables are not persistent between calls


def install():
    # Declaring local variables
    bin_name = glob.glob('vld-*-setup.exe')[0]

    # Uninstalling installed VLD versions
    for soft in installed_softwares("Visual Leak Detector"):
        print("Uninstalling %s (%s)" % (soft["name"], soft["version"]))
        run(soft["uninstall_string"] + "/VERYSILENT /SUPPRESSMSGBOXES /CLOSEAPPLICATIONS /NORESTART")

    # Installing the software
    install_exe_if_needed(bin_name,
        silentflags='/VERYSILENT /SUPPRESSMSGBOXES /CLOSEAPPLICATIONS /NORESTART',
        key='{851FBFF7-5148-40A2-A654-942BE80F5B90}_is1',
        min_version=control.get_software_version(),
    )