
# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob
import re



def update_package():
    # Declaring local variables
    package_updated = False

    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()


    url_base = "https://vivaldi.com/fr/download/"
    response = requests.get(url_base,allow_redirects=True, proxies=proxies)
    # Extract the correct div using bs_find_all
    links = bs_find_all(url_base, "a","class","download-link", proxies=proxies)
    exe_file = None
    for link in links:
        if link['href'].endswith('amd64.deb'):
            href = link['href']
            exe_file = href
            download_url = exe_file
            latest_bin = exe_file.split('/')[-1]
            version = latest_bin.split("_")[1].replace("_amd64.deb", "")
            version = version.split('-')[0]
            break


    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
        package_updated = True
    else:
        print("Binary is present: %s" % latest_bin)


    # Deleting outdated binaries
    for f in glob.glob('*.deb'):
        if f != latest_bin:
            remove_file(f)

    # Mettre à jour le package
    control.set_software_version(version)
    control.save_control_to_wapt()


