# -*- coding: utf-8 -*-
from setuphelpers import *

app_install_path = makepath(programfiles, "Oracle", "VirtualBox")
app_vbm = makepath(app_install_path, "VBoxManage.exe")


def install():
    # Avoid VMs to be shutted unexpectedly
    if isrunning("virtualbox") and not force:
        error("ERROR: VirtualBox is running")
    else:
        # Uninstalling the software if install forced
        for to_uninstall in installed_softwares("VirtualBox"):
            print("Removing: %s" % to_uninstall["name"])
            killalltasks(control.get_impacted_process_list())
            run(uninstall_cmd(to_uninstall["key"]))
            wait_uninstallkey_absent(to_uninstall["key"])

    # Adding certs
    try:
        for crt in glob.glob("oracle*.cer"):
            run(r"C:\Windows\System32\certutil.exe -addstore TrustedPublisher %s" % crt)
    except:
        for crt in glob.glob("oracle*.cer"):
            run(r"C:\Windows\System32\certutil.exe -addstore -f TrustedPublisher %s" % crt)
    # Installing the package
    bin_name = glob.glob("VirtualBox-*.exe")[0]
    install_exe_if_needed(
        bin_name,
        silentflags="--silent --msiparams REBOOT=ReallySuppress ALLUSERS=2 VBOX_INSTALLDESKTOPSHORTCUT=0 VBOX_START=0 VBOX_INSTALLQUICKLAUNCHSHORTCUT=0",
        name="Oracle VirtualBox " + control.get_software_version(),
        min_version=control.get_software_version(),
    )

    # Remove all file extpack
    for file in glob.glob(makepath(app_install_path, "Oracle_VirtualBox_Extension_Pack-*.vbox-extpack")):
        print("Removing: %s" % file)
        remove_file(file)
    # Copy new extpack
    for ext in glob.glob("Oracle_VirtualBox_Extension_Pack-*.vbox-extpack"):
        print("Copying: %s to: %s" % (ext, app_install_path))
        filecopyto(ext, app_install_path)
        # Install new extpack
        try:
            print(
                run(
                    'echo y | "%s" extpack install --replace "%s" --accept-license=33d7284dc4a0ece381196fda3cfe2ed0e1e8e7ed7f27b9a9ebc4ee22e24bd23c'
                    % (app_vbm, ext)
                )
            )
        except:
            print(run('"%s" extpack cleanup' % (app_vbm)))
            print(
                run(
                    'echo y | "%s" extpack install --replace "%s" --accept-license=33d7284dc4a0ece381196fda3cfe2ed0e1e8e7ed7f27b9a9ebc4ee22e24bd23c'
                    % (app_vbm, ext)
                )
            )


def session_setup():
    print("Disabling: Auto update checks")
    try:
        run('"%s" setextradata global GUI/UpdateDate never' % app_vbm)
    except:
        pass


def uninstall():
    if not installed_softwares("Oracle VM VirtualBox"):
        if isdir(app_install_path):
            remove_tree(app_install_path)
