# -*- coding: utf-8 -*-
from setuphelpers import *


#https://support.avigilon.com/s/article/Video-Manager-How-to-Reinstall-Video-Manager?language=en_US
do_delete_database = True

def install():
    # Declaring local variables

    def get_version(key):
        return key['version'].strip('V')

    #https://support.avigilon.com/s/article/How-to-Upgrade-Video-Manager?language=en_US
    for soft in installed_softwares(uninstallkey='VideoManager'):
        if get_version(soft) < control.get_software_version():
            run(uninstall_cmd('VideoManager'))
            if do_delete_database:
                delete_database()

    if need_install(key='VideoManager', min_version=control.get_software_version(),get_version=get_version):
        if isdir(r'C:\ProgramData\Motorola Solutions'):
            print("be careful it is sometimes necessary to delete the database (r'C:\ProgramData\Motorola Solutions') for the installation to work..")
    
    install_exe_if_needed('videomanager_setup_x64_%s.exe' % control.get_software_version().replace('.', '_'),
        silentflags='/S',
        key='VideoManager',
        min_version=control.get_software_version(),
        get_version=get_version,
    )


def uninstall():
    if do_delete_database:
        delete_database()

def delete_database():
    nb = 0
    while True:
        nb = nb + 1
        if nb > 120:
            break
        try:
            remove_tree(r'C:\ProgramData\Motorola Solutions')
            time.sleep(1)
            break
        except:
            time.sleep(1)