# -*- coding: utf-8 -*-
from setuphelpers import *
import glob

app_name = "vidcoder"

app_dir = makepath(programfiles, app_name)



def install():
    bin_name = glob.glob('*.exe')[0]
    app_path = makepath(app_dir, bin_name)
    # Installing software
    killalltasks(ensure_list(control.impacted_process))
    if isdir(app_dir) and force:
        remove_tree(app_dir)
    mkdirs(app_dir)
    filecopyto(bin_name, app_path)

    # Creating shortcuts
    create_desktop_shortcut(app_name, target=app_path)
    create_programs_menu_shortcut(app_name, target=app_path)


def uninstall():
    # Uninstalling software
    killalltasks(ensure_list(control.impacted_process))
    for uninstall in installed_softwares('vidcoder'):
        uninstall_string = uninstall.get("uninstall_string", "")
        print(f"Uninstalling vidcoder: {uninstall_string}")
        run(f"{uninstall_string} --uninstall --uninstall -s")
        wait_uninstallkey_absent(uninstall['key'],max_loop=600)
    if isdir(app_dir):
        remove_tree(app_dir)

    # Removing shortcuts
    remove_desktop_shortcut(app_name)
    remove_programs_menu_shortcut(app_name)
