# -*- coding: utf-8 -*-
from setuphelpers import *
import json


def update_package():
    # Declaring local variables
    package_updated = False
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()
    api_url = "https://api.github.com/repos/veyon/veyon/releases/latest"
    arch_dict = {"x64": "-win64-setup.exe", "x86": "win32-setup.exe"}

    # Getting latest version information from official sources
    print("API used is: %s" % api_url)
    json_load = json.loads(wgets(api_url, proxies=proxies))
    version = "1.0"
    for to_download in json_load["assets"]:
        if arch_dict[control.architecture] in to_download["name"] and Version(to_download["name"].split("-")[1]) >= Version(version):
            version = to_download["name"].split("-")[1]
            download_url = to_download["browser_download_url"]
            latest_bin = to_download["name"]

    # Downloading latest binaries
    print("Latest %s version is: %s" % (control.name, version))
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
    else:
        print("Binary is present: %s" % latest_bin)

    # Checking version from file
    version_from_file = get_version_from_binary(latest_bin)
    if Version(version_from_file, 4) != Version(version, 4) and version_from_file != "":
        print("Changing version to the version number of the binary")
        # os.rename(latest_bin, latest_bin.replace(version, version_from_file))
        version = version_from_file
    else:
        print("Binary file version corresponds to online version")

    # Changing version of the package
    if Version(version, 4) > Version(control.get_software_version(), 4):
        print("Software version updated (from: %s to: %s)" % (control.get_software_version(), Version(version)))
        package_updated = True
    else:
        print("Software version up-to-date (%s)" % Version(version))
    control.set_software_version(version)
    control.save_control_to_wapt()

    # Deleting outdated binaries
    remove_outdated_binaries(version)

    # Validating update-package-sources
    return package_updated
