# -*- coding: utf-8 -*-
from setuphelpers import *

bin_name_x86 = "VC_redist.x86.exe"
bin_name_x64 = "VC_redist.x64.exe"
bin_name_arm64 = "VC_redist.arm64.exe"

url_dl_x86 = "https://aka.ms/vs/17/release/VC_redist.x86.exe"
url_dl_x64 = "https://aka.ms/vs/17/release/VC_redist.x64.exe"
url_dl_arm64 = 'https://aka.ms/vs/17/release/VC_redist.arm64.exe'


def update_package():
    # Initializing variables
    proxies = get_proxies()
    if not proxies:
        proxies = get_proxies_from_wapt_console()

    # Downloading binaries
    print("Downloading " + bin_name_arm64)
    wget(url_dl_arm64, bin_name_arm64, proxies=proxies)

    print("Downloading " + bin_name_x64)
    wget(url_dl_x64, bin_name_x64, proxies=proxies)

    print("Downloading " + bin_name_x86)
    wget(url_dl_x86, bin_name_x86, proxies=proxies)

    # Changing version of the package
    version = get_version_from_binary(bin_name_x86)
    control.set_software_version(version)
    control.save_control_to_wapt()

    print(f"Changing package version to: {version} in WAPT\\control")
