# -*- coding: utf-8 -*-
from setuphelpers import *
import platform


bin_name_x86 = "VC_redist.x86.exe"
uninstall_key_x86 = r"Microsoft Visual C\+\+ 2015-2022 Redistributable \(x86\)"

bin_name_x64 = "VC_redist.x64.exe"
uninstall_key_x64 = r"Microsoft Visual C\+\+ 2015-2022 Redistributable \(x64\)"

bin_name_arm64 = 'VC_redist.arm64.exe'
uninstall_key_arm64 = r"Microsoft Visual C\+\+ 2022 Redistributable \(Arm64\)"

silent_args = "/quiet /norestart"


def install():

    vers = control.get_software_version()

    install_exe_if_needed(
        bin_name_x86,
        silent_args,
        min_version=vers,
        name=uninstall_key_x86
    )
    
    if iswin64() or iswinarm():
        install_exe_if_needed(
            bin_name_x64,
            silent_args,
            min_version=vers,
            name=uninstall_key_x64
        )
    
    if iswinarm():
        install_exe_if_needed(
            bin_name_arm64,
            silent_args,
            min_version=vers,
            name=uninstall_key_arm64
        )


def audit():

    vers = control.get_software_version()
    status = "OK"

    x86vers = installed_softwares(name=uninstall_key_x86)[0]['version']
    if Version(x86vers) > Version(vers):
        status = "WARNING"
        print(f"The version installed on the workstation is more recent (x86) ! {x86vers} ")

    if iswin64() or iswinarm():
        x64vers = installed_softwares(name=uninstall_key_x64)[0]['version']
        if Version(x64vers) > Version(vers):
            status = "WARNING"
            print(f"The version installed on the workstation is more recent (x64) ! {x64vers} ")
    
    if iswinarm():
        arm64vers = installed_softwares(name=uninstall_key_arm64)[0]['version']
        if Version(arm64vers) > Version(vers):
            status = "WARNING"
            print(f"The version installed on the workstation is more recent (arm64) ! {arm64vers} ")

    return status


def iswinarm():
    return platform.machine() == 'ARM64'