
# -*- coding: utf-8 -*-
from setuphelpers import *
from setupdevhelpers import *
import glob




def update_package():
    # Declaring local variables
    package_updated = False
    
    proxies = get_proxies_from_wapt_console()
    if not proxies:
        proxies = get_proxies()

    git_repo = "hashicorp/vault"
    url_api = "https://api.github.com/repos/%s/releases/latest" % git_repo   
    # Getting latest version information from official sources
    print("API used is: %s" % url_api)
    json_load = json.loads(wgets(url_api, proxies=proxies))

    version = json_load["tag_name"].replace("v","")
    latest_bin = f"vault_{version}_windows_386.zip"
    download_url = f"https://releases.hashicorp.com/vault/{version}/" +latest_bin


    # Downloading latest binaries
    print("Download URL is: %s" % download_url)
    if not isfile(latest_bin):
        print("Downloading: %s" % latest_bin)
        wget(download_url, latest_bin, proxies=proxies)
        package_updated = True
    else:
        print("Binary is present: %s" % latest_bin)


    # Deleting outdated binaries
    for f in glob.glob('*.zip'):
        if f != latest_bin:
            remove_file(f)

    # Mettre à jour le package
    control.set_software_version(version)
    control.save_control_to_wapt()    
        

