# -*- coding: utf-8 -*-
from setuphelpers import *


def get_version(app_registry_dict):
    version = app_registry_dict['version']
    version = version.replace('-patch', '.') if 'patch' in version else version.split('-')[0]
    return str(Version(version, 4))

def install():

    killalltasks(ensure_list(control.impacted_process))

    for soft in installed_softwares('Unciv'):
        unistall_key = soft['key']
        if Version(soft['version']) < Version(control.get_software_version()):
            run(uninstall_cmd(unistall_key))
            wait_uninstallkey_absent(unistall_key)
            
    # Declaring local variables
    bin_name = glob.glob(f"Unciv.msi")[0]
    
    install_msi_if_needed(
        bin_name,
        name='^Unciv$',
        min_version=control.get_software_version(),
        get_version=get_version
    )